<?php $__env->startSection('content'); ?>
    <?php if(isset($error)) { ?>
    <div class="row justify-content-center ins-seven">
        <div class="col-md-6">
            <div class="alert alert-danger">
                <strong><?php echo e($error); ?></strong>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="card">
        <div class="card-body">
            <div class="text-center pt-2">
                <img src="<?php echo e(asset('assets/install/images/logo.svg')); ?>" alt="" />
            </div>
            <div class="page-title">
                <h4> <?php echo e(__('Installation')); ?> </h4>
            </div>
            <p class="ins-p-2">
                <?php echo e(__('Your database is successfully connected')); ?>.
                <?php echo e(__('All you need to do now is hit the ')); ?>

                <strong><?php echo e(__("'Install'")); ?></strong> <?php echo e(__('button')); ?>.
                <?php echo e(__('The auto installer will run a sql file, will do all the tiresome works and set up your application automatically.')); ?>

            </p>
            <div class="d-flex align-items-center justify-content-between pt-2">
                <div>
                    <div id="loader" class="ins-seven mt-2">
                        <?php echo e(__('Importing database....')); ?>

                    </div>
                </div>
                <button type="button" id="install_button" class="ins-btn">
                    <?php echo e(__('Install')); ?>

                </button>
            </div>

            <ul class="ins-step">
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li></li>
            </ul>
            <span> <?php echo e(__('Step-4')); ?> </span>
            <div class="text-center">
                <p><?php echo e(__('Need any help?')); ?> <a href="https://creativeitem.com/" target="_blank"><?php echo e(__('Contact Us')); ?></a></p>
            </div>
        </div>
    </div>
    <!-- jQuery -->
    <script src="<?php echo e(asset('assets/frontend/js/jquery-3.7.1.min.js')); ?>"></script>
    <script type="text/javascript">
        "use strict";

        $(document).ready(function() {
            $('#loader').hide();
            $('#install_button').on('click', function() {
                $('#loader').fadeIn();
                setTimeout(
                    function() {
                        window.location.href = "<?php echo e(route('confirm_install')); ?>";
                    }, 5000);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('install.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/install/step4.blade.php ENDPATH**/ ?>