<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo $__env->yieldContent('title'); ?> </title>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/backend/images/favicon.svg')); ?>" type="image/x-icon">
    <!-- Bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/vendors/bootstrap/bootstrap.min.css')); ?>">
    <!-- UI Icon -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icons/uicons-bold-rounded/css/uicons-bold-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icons/uicons-bold-straight/css/uicons-bold-straight.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icons/uicons-regular-rounded/css/uicons-regular-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icons/uicons-thin-rounded/css/uicons-thin-rounded.css')); ?>" />

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icon-picker/fontawesome-iconpicker.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/icon-picker/icons/fontawesome-all.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugin/tagify-master/dist/tagify.css')); ?>">
    
    <!-- select 2 -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/select2.min.css')); ?>">
    <!-- datatable -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/dataTables.bootstrap5.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/responsive.bootstrap5.css')); ?>">
    <!-- toastr css -->
    <link rel="stylesheet" href="<?php echo e(asset('plugin/toastr/toastr.min.css')); ?>">
    <!-- Custom Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/responsive.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/custom.css')); ?>">
    <script src="<?php echo e(asset('assets/backend/js/jquery-3.7.1.min.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('css'); ?>

</head>
<body>
    <!-- Admin Main Top Area Start -->
    <main>
        <!-- Sidebar -->
        <div class="ol-sidebar">
            <?php echo $__env->make('admin.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="ol-sidebar-content">
            <?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Content -->
            <div class="ol-body-content">
                <div class="container-fluid">
                    <div class="ol-body-content-inner">

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger alert-dismissible">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <?php echo $__env->yieldContent('admin_layout'); ?>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

   

    <!-- Admin Main Top Area End -->
    <script src="<?php echo e(asset('assets/backend/vendors/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/vendors/chart-js/chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/icon-picker/fontawesome-iconpicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/dataTables.bootstrap5.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/js/dataTables.responsive.js')); ?>"></script>
    
    <script>
        "use strict";


        $('#datatable').DataTable({
            responsive: true
        })
     
     </script>
    <!-- toastr js -->
    <script src="<?php echo e(asset('plugin/toastr/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugin/tagify-master/dist/tagify.min.js')); ?>"></script>
    <?php echo Toastr::message(); ?>

    <script src="<?php echo e(asset('assets/backend/js/script.js')); ?>"></script>
    <!-- toster file -->
    <?php echo $__env->make('layouts.toaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('js'); ?>

</body>
</html>
<?php /**PATH C:\MAMP\htdocs\1.1Atlas\resources\views/layouts/admin.blade.php ENDPATH**/ ?>