<div class="toast-container position-fixed top-0 end-0 p-3"></div>
<script>
    "use strict";

    function toaster_message(type, icon, header, message) {
        var toasterMessage = '<div class="toast ' + type +
            ' fade text-12" role="alert" aria-live="assertive" aria-atomic="true" class="rounded-3"><div class="toast-header"> <i class="' +
            icon + ' me-2 mt-2px text-14 d-flex"></i> <strong class="me-auto"> ' + header +
            ' </strong><small><?php echo e(__('Just Now')); ?></small><button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button></div><div class="toast-body">' +
            message + '</div></div>';
        $('.toast-container').prepend(toasterMessage);
        const toast = new bootstrap.Toast('.toast')
        toast.show()
    }

    function success(message) {
        toaster_message('success', 'far fa-check-circle', '<?php echo e(__('Success !')); ?>', message);
    }
    function warning(message) {
        toaster_message('warning', 'far fa-check-circle', '<?php echo e(__('Attention !')); ?>', message);
    }

    function error(message) {
        toaster_message('error', 'fi-sr-triangle-warning', '<?php echo e(__('An Error Occurred !')); ?>', message);
    }
</script>

<?php if($message = Session::get('success')): ?>
    <script>
        "use strict";
        success("<?php echo e($message); ?>");
    </script>
    <?php Session()->forget('success'); ?>
<?php elseif($message = Session::get('warning')): ?>
    <script>
        "use strict";
        warning("<?php echo e($message); ?>");
    </script>
    <?php Session()->forget('warning'); ?>
<?php elseif($message = Session::get('error')): ?>
    <script>
        "use strict";
        error("<?php echo e($message); ?>");
    </script>
    <?php Session()->forget('error'); ?>
<?php elseif(isset($errors) && $errors->any()): ?>
    <?php
        $message = '<ul>';
        foreach ($errors->all() as $error):
            $message .= '<li>' . $error . '</li>';
        endforeach;
        $message .= '</ul>';
    ?>
    <script>
        "use strict";
        error("<?php echo $message; ?>");
    </script>
<?php endif; ?>
<?php /**PATH /Applications/MAMP/htdocs/atlas_laravel/Atlas-Laravel-Business-Directory-Listing/Atlas/resources/views/install/toaster.blade.php ENDPATH**/ ?>