<?php $__env->startSection('title', get_phrase('Cities')); ?>
<?php $__env->startSection('admin_layout'); ?>

<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                <?php echo e(get_phrase('City Lists')); ?>

            </h4>

            <a href="javascript:void(0)" onclick="modal('modal-md', '<?php echo e(route('admin.add-city')); ?>', '<?php echo e(get_phrase('Add New City')); ?>')" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                <span class="fi-rr-plus"></span>
                <span><?php echo e(get_phrase('Add new City')); ?></span>
            </a>
        </div>
    </div>
</div>
<div class=" mt-3">
    <div class="ol-card-body py-3">
        <?php if(count($cities)): ?>
        <div class="row g-4 all-category-list">
            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-lg-4 col-xl-3">
                    <div class="ol-card category-card radious-10px h-100">
                        <img src="<?php echo e(get_all_image('country-thumbnails/'.$country->thumbnail)); ?>" class="card-img-top" alt="...">
                        <h6 class="title fs-14px mb-12px px-3 pt-3 d-flex align-baseline">
                            <?php echo e($country->name); ?> <span class="text-muted d-inline-block ms-auto">(<?php echo e($country->country_to_city->count()); ?>)</span>
                        </h6>
                        <div class="ol-card-body">
                            <ul class="list-group list-group-flush">
                                <?php $__currentLoopData = $country->country_to_city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item text-muted">
                                        <div class="row">
                                            <div class="col-auto">
                                                <i class="<?php echo e($city->icon); ?>"></i> <span class="text-12px"><?php echo e($city->name); ?></span>
                                            </div>
                                            <div class="col-auto ms-auto d-flex subcategory-actions">
                                                <a onclick="edit_modal('modal-md','<?php echo e(route('admin.edit-city',['id'=>$city->id])); ?>','<?php echo e(get_phrase('Edit City')); ?>')" class="mx-1" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Edit')); ?>" href="#"><i class="fi fi-rr-pen-clip"></i></a>
                                                <a onclick="delete_modal('<?php echo e(route('admin.delete-city',['id'=>$city->id])); ?>')" class="mx-1" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Delete')); ?>" href="#"><i class="fi fi-rr-trash"></i></a>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class=" outBtn  w-100  text-center py-1">
                            <a onclick="edit_modal('modal-md','<?php echo e(route('admin.edit-country',['id'=>$country->id])); ?>','<?php echo e(get_phrase('Edit Country')); ?>')" class="btn ol-btn-outline-secondary category-footer  w-100 text-12px fw-600"><i class="fi fi-rr-pen-clip"></i> <?php echo e(get_phrase('Edit')); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
            <?php echo $__env->make('layouts.no_data_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </div>
</div> 

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\demoA\AtlasA\resources\views/admin/city/index.blade.php ENDPATH**/ ?>