
<?php if(request()->is('hotel/home')): ?>
<div class="ht-header-banner-wrap" style="background-image: url('<?php echo e(isset($HotelBanner->image) && $HotelBanner->image ? asset('uploads/homepage/hotel/' . $HotelBanner->image) : asset('assets/frontend/images/hotel/hotel-hero-banner.svg')); ?>');">
    <!-- Start Header -->
    <header class="ht-home-header">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="at-home-menu-wrap">
                        <div>
                            <a href="<?php echo e(route('home')); ?>">
                                <?php if(get_frontend_settings('dark_logo')): ?>
                                <img src="<?php echo e(asset('uploads/logo/' . get_frontend_settings('dark_logo'))); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                            <?php else: ?>
                                <img src="<?php echo e(asset('uploads/logo/dark_logo.svg')); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                            <?php endif; ?>
                            </a>
                        </div>
                        <div class="at-home-menu-button ht-home-menu-button">
                            <!-- offcanvas menu start -->
                            <div class="offcanvas-xl offcanvas-end at-home-offcanvas" tabindex="-1" id="offcanvasResponsive" aria-labelledby="offcanvasResponsiveLabel">
                                <div class="offcanvas-header">
                                    <div>
                                        <a href="<?php echo e(route('home')); ?>">
                                            <?php if(get_frontend_settings('light_logo')): ?>
                                            <img src="<?php echo e(asset('uploads/logo/' . get_frontend_settings('light_logo'))); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('uploads/logo/light_logo.svg')); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                                        <?php endif; ?>
                                        </a>
                                    </div>
                                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" data-bs-target="#offcanvasResponsive" aria-label="Close"></button>
                                </div>
                                <div class="offcanvas-body">
                                    <nav>
                                        <ul class="at-home-navbar-nav ht-home-navbar-nav">
                                             <?php
                                            $menu_items = json_decode(get_frontend_settings('menu')); 
                                        ?>
                                        <?php $__currentLoopData = $menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($key < 2): ?> 
                                                <?php if($item == 'Hotel'): ?> 
                                                    <li><a class="at-home-nav-link <?php echo e(request()->routeIs('hotel.home') ? 'active' : ''); ?>" href="<?php echo e(route('hotel.home')); ?>"><?php echo e(get_phrase('Hotel')); ?></a></li>
                                                <?php elseif($item == 'Real-Estate'): ?> 
                                                    <li><a class="at-home-nav-link <?php echo e(request()->routeIs('real-estate.home') ? 'active' : ''); ?>" href="<?php echo e(route('real-estate.home')); ?>"><?php echo e(get_phrase('Real Estate')); ?></a></li>
                                                <?php elseif($item == 'Car'): ?> 
                                                    <li><a class="at-home-nav-link <?php echo e(request()->routeIs('car.home') ? 'active' : ''); ?>" href="<?php echo e(route('car.home')); ?>"><?php echo e(get_phrase('Car')); ?></a></li>
                                                <?php elseif($item == 'Restaurant'): ?> 
                                                    <li><a class="at-home-nav-link <?php echo e(request()->routeIs('restaurant.home') ? 'active' : ''); ?>" href="<?php echo e(route('restaurant.home')); ?>"><?php echo e(get_phrase('Restaurant')); ?></a></li>
                                                <?php elseif($item == 'Beauty'): ?> 
                                                    <li><a class="at-home-nav-link <?php echo e(request()->routeIs('beauty.home') ? 'active' : ''); ?>" href="<?php echo e(route('beauty.home')); ?>"><?php echo e(get_phrase('Beauty')); ?></a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                        <?php if(count($menu_items) > 2): ?>
                                            <li class="have-sub-menu hSubmenu">
                                                <a href="javascript:void(0);" class="at-home-nav-link first-a">
                                                    <span><?php echo e(get_phrase('More')); ?></span>
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M15.5917 7.84025C15.5142 7.76214 15.422 7.70015 15.3205 7.65784C15.2189 7.61553 15.11 7.59375 15 7.59375C14.89 7.59375 14.7811 7.61553 14.6795 7.65784C14.578 7.70015 14.4858 7.76214 14.4083 7.84025L10.5917 11.6569C10.5142 11.735 10.422 11.797 10.3205 11.8393C10.2189 11.8816 10.11 11.9034 10 11.9034C9.89 11.9034 9.78108 11.8816 9.67953 11.8393C9.57798 11.797 9.48581 11.735 9.40834 11.6569L5.59168 7.84025C5.51421 7.76214 5.42204 7.70015 5.32049 7.65784C5.21894 7.61553 5.11002 7.59375 5.00001 7.59375C4.89 7.59375 4.78108 7.61553 4.67953 7.65784C4.57798 7.70015 4.48581 7.76214 4.40834 7.84025C4.25313 7.99638 4.16602 8.20759 4.16602 8.42775C4.16602 8.6479 4.25313 8.85911 4.40834 9.01525L8.23334 12.8402C8.70209 13.3084 9.33751 13.5714 10 13.5714C10.6625 13.5714 11.2979 13.3084 11.7667 12.8402L15.5917 9.01525C15.7469 8.85911 15.834 8.6479 15.834 8.42775C15.834 8.20759 15.7469 7.99638 15.5917 7.84025Z" fill="#555558"/>
                                                    </svg>                                                    
                                                </a>
                                                <ul class="first-sub-menu">
                                                    <?php $__currentLoopData = $menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($key >= 2): ?> 
                                                            <?php if($item == 'Hotel'): ?> 
                                                                <li><a class=" <?php echo e(request()->routeIs('hotel.home') ? 'active' : ''); ?>" href="<?php echo e(route('hotel.home')); ?>"><?php echo e(get_phrase('Hotel')); ?></a></li>
                                                            <?php elseif($item == 'Real-Estate'): ?> 
                                                                <li><a class=" <?php echo e(request()->routeIs('real-estate.home') ? 'active' : ''); ?>" href="<?php echo e(route('real-estate.home')); ?>"><?php echo e(get_phrase('Real Estate')); ?></a></li>
                                                            <?php elseif($item == 'Car'): ?> 
                                                                <li><a class=" <?php echo e(request()->routeIs('car.home') ? 'active' : ''); ?>" href="<?php echo e(route('car.home')); ?>"><?php echo e(get_phrase('Car')); ?></a></li>
                                                            <?php elseif($item == 'Restaurant'): ?> 
                                                                <li><a class="atn-sub-nav-link <?php echo e(request()->routeIs('restaurant.home') ? 'active' : ''); ?>" href="<?php echo e(route('restaurant.home')); ?>"><?php echo e(get_phrase('Restaurant')); ?></a></li>
                                                            <?php elseif($item == 'Beauty'): ?> 
                                                                <li><a class="atn-sub-nav-link <?php echo e(request()->routeIs('beauty.home') ? 'active' : ''); ?>" href="<?php echo e(route('beauty.home')); ?>"><?php echo e(get_phrase('Beauty')); ?></a></li>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>
                                        <?php endif; ?>
                                    
                                        <li><a href="<?php echo e(route('listing.view', ['type' => 'hotel', 'view' => 'grid'])); ?>" 
                                               class="at-home-nav-link <?php echo e(request()->routeIs('listing.view') ? 'active' : ''); ?>">
                                               <?php echo e(get_phrase('Listing')); ?>

                                        </a></li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                            <!-- offcanvas menu end -->
                            <div class="at-home-search-login-button">
                                <div class="at-home-nav-search ht-home-nav-search d-none d-md-block">
                                    <form class="at-home-search-form" action="<?php echo e(route('ListingsFilter')); ?>" method="get">
                                        <input type="hidden" name="type" value="hotel">
                                        <input type="hidden" name="view" value="grid">
                                       <div class="at-home-nav-label">
                                            <input type="search" class="at-home-search-input car-home-search-input" placeholder="Search …"  title="Search for:" name="title">
                                            <button type="submit" class="at-home-search-btn ca-home-search-btn">
                                                <img src="<?php echo e(asset('assets/frontend/images/icons/search-white-16.svg')); ?>" alt="">
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <?php if(user('role') == 1): ?>
                                <div class="dropdown at-user-dropdown">
                                    <button class="btn user-dropdown-toggle dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                        <img src="<?php echo e(user('image') ? asset('storage/users/' . user('image')) : asset('image/user.jpg')); ?>" alt="">
                                    </button>
                                    <div class="dropdown-menu user-dropdown-menu">
                                        <ul class="user-dropdown-group">
                                            <li><a class="user-dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>">
                                                <span class="icon fi-rr-apps mt-2px"></span>
                                                <span class="mt-2px"><?php echo e(get_phrase('Dashboard')); ?></span>
                                            </a></li>
                                        </ul>
                                        <div class="px-10px py-12px">
                                            <a href="<?php echo e(route('logout')); ?>" class="user-dropdown-item">
                                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M10.1599 14.8467L10.0733 14.8467C7.11326 14.8467 5.6866 13.68 5.43993 11.0667C5.41326 10.7933 5.61326 10.5467 5.89326 10.52C6.15993 10.4933 6.41326 10.7 6.43993 10.9733C6.63326 13.0667 7.61993 13.8467 10.0799 13.8467L10.1666 13.8467C12.8799 13.8467 13.8399 12.8867 13.8399 10.1733L13.8399 5.82665C13.8399 3.11332 12.8799 2.15332 10.1666 2.15332L10.0799 2.15332C7.6066 2.15332 6.61993 2.94665 6.43993 5.07999C6.4066 5.35332 6.17326 5.55999 5.89326 5.53332C5.61326 5.51332 5.41326 5.26665 5.43326 4.99332C5.65993 2.33999 7.09326 1.15332 10.0733 1.15332L10.1599 1.15332C13.4333 1.15332 14.8333 2.55332 14.8333 5.82665L14.8333 10.1733C14.8333 13.4467 13.4333 14.8467 10.1599 14.8467Z" fill="#99A1B7"/>
                                                    <path d="M10 8.5L2.41333 8.5C2.14 8.5 1.91333 8.27333 1.91333 8C1.91333 7.72667 2.14 7.5 2.41333 7.5L10 7.5C10.2733 7.5 10.5 7.72667 10.5 8C10.5 8.27333 10.2733 8.5 10 8.5Z" fill="#99A1B7"/>
                                                    <path d="M3.89988 10.7333C3.77321 10.7333 3.64655 10.6866 3.54655 10.5866L1.31321 8.35331C1.11988 8.15998 1.11988 7.83998 1.31321 7.64664L3.54655 5.41331C3.73988 5.21998 4.05988 5.21998 4.25321 5.41331C4.44655 5.60664 4.44655 5.92664 4.25321 6.11998L2.37321 7.99998L4.25321 9.87998C4.44655 10.0733 4.44655 10.3933 4.25321 10.5866C4.15988 10.6866 4.02655 10.7333 3.89988 10.7333Z" fill="#99A1B7"/>
                                                </svg>
                                                <span class="mt-2px"><?php echo e(get_phrase('Log Out')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php elseif(user('role') == 2): ?>
                                <div class="dropdown at-user-dropdown">
                                    <button class="btn user-dropdown-toggle dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                        <img src="<?php echo e(user('image') ? asset('storage/users/' . user('image')) : asset('image/user.jpg')); ?>" alt="">
                                    </button>
                                    <div class="dropdown-menu user-dropdown-menu">
                                        <ul class="user-dropdown-group">
                                            <li><a class="user-dropdown-item" href="<?php echo e(route('user.account')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M9.99992 15.1666H5.99992C2.37992 15.1666 0.833252 13.6199 0.833252 9.99992V5.99992C0.833252 2.37992 2.37992 0.833252 5.99992 0.833252H7.33325C7.60659 0.833252 7.83325 1.05992 7.83325 1.33325C7.83325 1.60659 7.60659 1.83325 7.33325 1.83325H5.99992C2.92658 1.83325 1.83325 2.92658 1.83325 5.99992V9.99992C1.83325 13.0733 2.92658 14.1666 5.99992 14.1666H9.99992C13.0733 14.1666 14.1666 13.0733 14.1666 9.99992V8.66658C14.1666 8.39325 14.3933 8.16658 14.6666 8.16658C14.9399 8.16658 15.1666 8.39325 15.1666 8.66658V9.99992C15.1666 13.6199 13.6199 15.1666 9.99992 15.1666Z" fill="#99A1B7"/>
                                                    <path d="M5.66664 11.7934C5.25997 11.7934 4.88664 11.6467 4.61331 11.38C4.28664 11.0534 4.14664 10.58 4.21997 10.08L4.50664 8.07337C4.55997 7.68671 4.8133 7.18671 5.08664 6.91337L10.34 1.66004C11.6666 0.333372 13.0133 0.333372 14.34 1.66004C15.0666 2.38671 15.3933 3.12671 15.3266 3.86671C15.2666 4.46671 14.9466 5.05337 14.34 5.65337L9.08664 10.9067C8.8133 11.18 8.3133 11.4334 7.92664 11.4867L5.91997 11.7734C5.8333 11.7934 5.74664 11.7934 5.66664 11.7934ZM11.0466 2.36671L5.7933 7.62004C5.66664 7.74671 5.51997 8.04004 5.4933 8.21337L5.20664 10.22C5.17997 10.4134 5.21997 10.5734 5.31997 10.6734C5.41997 10.7734 5.57997 10.8134 5.7733 10.7867L7.77997 10.5C7.9533 10.4734 8.2533 10.3267 8.3733 10.2L13.6266 4.94671C14.06 4.51337 14.2866 4.12671 14.32 3.76671C14.36 3.33337 14.1333 2.87337 13.6266 2.36004C12.56 1.29337 11.8266 1.59337 11.0466 2.36671Z" fill="#99A1B7"/>
                                                    <path d="M13.2333 6.55343C13.1866 6.55343 13.14 6.54677 13.1 6.53343C11.3466 6.0401 9.95329 4.64677 9.45996 2.89343C9.38662 2.62677 9.53996 2.35343 9.80662 2.27343C10.0733 2.2001 10.3466 2.35343 10.42 2.6201C10.82 4.0401 11.9466 5.16677 13.3666 5.56677C13.6333 5.6401 13.7866 5.9201 13.7133 6.18677C13.6533 6.41343 13.4533 6.55343 13.2333 6.55343Z" fill="#99A1B7"/>
                                                </svg>
                                                <span class="mt-2px"><?php echo e(get_phrase('Profile')); ?></span>
                                            </a></li>
                                        </ul>
                                        <div class="px-10px py-12px">
                                            <a href="<?php echo e(route('logout')); ?>" class="user-dropdown-item">
                                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M10.1599 14.8467L10.0733 14.8467C7.11326 14.8467 5.6866 13.68 5.43993 11.0667C5.41326 10.7933 5.61326 10.5467 5.89326 10.52C6.15993 10.4933 6.41326 10.7 6.43993 10.9733C6.63326 13.0667 7.61993 13.8467 10.0799 13.8467L10.1666 13.8467C12.8799 13.8467 13.8399 12.8867 13.8399 10.1733L13.8399 5.82665C13.8399 3.11332 12.8799 2.15332 10.1666 2.15332L10.0799 2.15332C7.6066 2.15332 6.61993 2.94665 6.43993 5.07999C6.4066 5.35332 6.17326 5.55999 5.89326 5.53332C5.61326 5.51332 5.41326 5.26665 5.43326 4.99332C5.65993 2.33999 7.09326 1.15332 10.0733 1.15332L10.1599 1.15332C13.4333 1.15332 14.8333 2.55332 14.8333 5.82665L14.8333 10.1733C14.8333 13.4467 13.4333 14.8467 10.1599 14.8467Z" fill="#99A1B7"/>
                                                    <path d="M10 8.5L2.41333 8.5C2.14 8.5 1.91333 8.27333 1.91333 8C1.91333 7.72667 2.14 7.5 2.41333 7.5L10 7.5C10.2733 7.5 10.5 7.72667 10.5 8C10.5 8.27333 10.2733 8.5 10 8.5Z" fill="#99A1B7"/>
                                                    <path d="M3.89988 10.7333C3.77321 10.7333 3.64655 10.6866 3.54655 10.5866L1.31321 8.35331C1.11988 8.15998 1.11988 7.83998 1.31321 7.64664L3.54655 5.41331C3.73988 5.21998 4.05988 5.21998 4.25321 5.41331C4.44655 5.60664 4.44655 5.92664 4.25321 6.11998L2.37321 7.99998L4.25321 9.87998C4.44655 10.0733 4.44655 10.3933 4.25321 10.5866C4.15988 10.6866 4.02655 10.7333 3.89988 10.7333Z" fill="#99A1B7"/>
                                                </svg>
                                                <span class="mt-2px"><?php echo e(get_phrase('Log Out')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php else: ?>
                                    <a href="<?php echo e(route('login')); ?>" class="login at-home-nav-link"><?php echo e(get_phrase('Login')); ?></a>
                                <?php endif; ?>
                                <?php if(check_subscription(user('id'))): ?> 
                                <a href="<?php echo e(route('agent.my_listings')); ?>" class="btn ht-btn-primary at-home-listing-btn d-flex align-items-center gap-2">
                                    <img src="<?php echo e(asset('assets/frontend/images/icons/plus-white-8.svg')); ?>" alt="icon">
                                    <span><?php echo e(get_phrase('Add Listing')); ?></span>
                                </a>
                                <?php else: ?> 
                                <a href="<?php echo e(route('customer.become_an_agent')); ?>" class="btn ht-btn-primary at-home-listing-btn d-flex align-items-center gap-2">
                                    <img src="<?php echo e(asset('assets/frontend/images/icons/plus-white-8.svg')); ?>" alt="icon">
                                    <span><?php echo e(get_phrase('Add Listing')); ?></span>
                                </a>
                                <?php endif; ?>
                                <button class="btn at-home-menu-btn ht-home-menu-btn d-xl-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasResponsive" aria-controls="offcanvasResponsive">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" x="0" y="0" viewBox="0 0 24 24" style="enable-background:new 0 0 20 20" xml:space="preserve" class=""><g><path d="M21 7H8a1 1 0 0 1 0-2h13a1 1 0 0 1 0 2zm1 5a1 1 0 0 0-1-1H3a1 1 0 0 0 0 2h18a1 1 0 0 0 1-1zm0 6a1 1 0 0 0-1-1h-9a1 1 0 0 0 0 2h9a1 1 0 0 0 1-1z" fill="#6c1cff" opacity="1" data-original="#000000" class=""></path></g></svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- End Header -->
  
    <!-- Start Banner Area -->
    <section class="ht-banner-section mb-60px">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <p class="dm-uppercase-text-16px text-center"><?php echo e(get_phrase('Hotel')); ?></p>
                    <h1 class="dm-title-60px text-capitalize fw-semibold text-white mb-20px text-center"><?php echo e($HotelBanner->title ?? ''); ?></h1>
                    <p class="in-subtitle-16px text-white text-center max-w-723px mx-auto mb-40px"><?php echo e($HotelBanner->description ?? ''); ?></p>
                    <div class="mb-50px d-flex align-items-center gap-3 flex-wrap justify-content-center">
                        <a href="<?php echo e(route('listing.view',['type'=>'hotel','view'=>'grid'])); ?>" class="btn ht-btn-primary"><?php echo e(get_phrase('Learn More')); ?></a>

                        <a href="<?php echo e($HotelBanner->video_url ?? asset('image/placeholder.png')); ?>" 
                            class="ht-play-btn video-popup d-flex align-items-center gap-12px" 
                            data-maxwidth="900px" 
                            data-vbtype="<?php echo e($HotelBanner->video_url ? 'video' : ''); ?>">
                             <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <circle cx="24" cy="24" r="23.5" stroke="white"/>
                                 <path d="M30.05 25.2138C29.9905 25.2761 29.7656 25.5422 29.5563 25.7611C28.3287 27.138 25.1261 29.3917 23.4499 30.0796C23.1953 30.1901 22.5517 30.4241 22.2079 30.4391C21.8784 30.4391 21.5643 30.3618 21.2645 30.2051C20.8909 29.9862 20.5912 29.6417 20.427 29.235C20.3212 28.9527 20.157 28.1082 20.157 28.0931C19.9928 27.1691 19.9024 25.6678 19.9024 24.0086C19.9024 22.4279 19.9928 20.9877 20.1272 20.0497C20.1426 20.0347 20.3069 18.9851 20.4865 18.6256C20.816 17.9688 21.4596 17.561 22.1483 17.561H22.2079C22.6564 17.5771 23.5997 17.9849 23.5997 18C25.1856 18.6889 28.3142 20.8321 29.5717 22.2562C29.5717 22.2562 29.9258 22.6221 30.0797 22.8507C30.32 23.1791 30.439 23.5858 30.439 23.9925C30.439 24.4465 30.3046 24.8693 30.05 25.2138Z" fill="white"/>
                             </svg>
                             <span><?php echo e(get_phrase('Take A Tour')); ?></span>
                         </a>
                         
                    </div>
                    <div class="at2-shadow-card mx-auto max-sm-350px">
                        <?php 
                           $cities = App\Models\HotelListing::select('city')->groupBy('city')->get();
                           $countries = App\Models\HotelListing::select('country')->groupBy('country')->get(); 
                        ?>
                        <form action="<?php echo e(route('ListingsFilter')); ?>" method="get">
                            <input type="hidden" name="type" value="hotel">
                            <input type="hidden" name="view" value="grid">
                            <div class="d-flex align-items-start align-items-sm-center ht-search-filter-wrap flex-wrap justify-content-center justify-content-md-Start flex-column flex-sm-row">
                                <div class="ht-search-filter ht-search-filter-border">
                                    <div class="d-flex align-items-center gap-2 mb-6px">
                                        <img src="<?php echo e(asset('assets/frontend/images/category.svg')); ?>" alt="">
                                        <p class="dm-text-16px"><?php echo e(get_phrase('Category')); ?></p>
                                    </div>
                                    <select class="at-nice-select transparent-nice-select ms-32px min-w-145px" name='category'>
                                        <option data-display="Select category"><?php echo e(get_phrase('Select Category')); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="ht-search-filter ht-search-filter-border">
                                    <div class="d-flex align-items-center gap-2 mb-6px">
                                        <img src="<?php echo e(asset('assets/frontend/images/Type.svg')); ?>" alt="icon">
                                        <p class="dm-text-16px"><?php echo e(get_phrase('Type')); ?></p>
                                    </div>
                                    <select class="at-nice-select transparent-nice-select ms-32px min-w-120px" name="is_popular">
                                        <option data-display="Select Type"><?php echo e(get_phrase('Select Type')); ?></option>
                                        <option value="top"><?php echo e(get_phrase('Top')); ?></option>
                                        <option value="popular"><?php echo e(get_phrase('Popular')); ?></option>
                                    </select>
                                </div>
                                <div class="ht-search-filter ht-search-filter-border">
                                    <div class="d-flex align-items-center gap-2 mb-6px">
                                        <img src="<?php echo e(asset('assets/frontend/images/City.svg')); ?>" alt="icon">
                                        <p class="dm-text-16px"><?php echo e(get_phrase('Cities')); ?></p>
                                    </div>
                                    <select class="at-nice-select transparent-nice-select ms-32px min-w-120px" name="city">
                                        <option data-display="Select City"><?php echo e(get_phrase('Select City')); ?></option>
                                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cityName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                                        <?php
                                            $city = App\Models\City::where('id', $cityName->city)->first();
                                        ?>
                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="ht-search-filter ht-search-filter-border">
                                    <div class="d-flex align-items-center gap-2 mb-6px">
                                        <img src="<?php echo e(asset('assets/frontend/images/Country.svg')); ?>" alt="icon">
                                        <p class="dm-text-16px"><?php echo e(get_phrase('Country')); ?></p>
                                    </div>
                                    <select class="at-nice-select transparent-nice-select ms-32px min-w-120px" name="country">
                                        <option data-display="Select Country"><?php echo e(get_phrase('Select Country')); ?></option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $countryName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                                        <?php
                                            $country = App\Models\Country::where('id', $countryName->country)->first();
                                        ?>
                                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                               
                                <button type="submit" class="mx-auto mx-sm-0 btn ht-btn-primary d-flex align-items-center gap-2">
                                    <img src="<?php echo e(asset('assets/frontend/images/icons/search-white-20.svg')); ?>" alt="icon">
                                    <span><?php echo e(get_phrase('Search')); ?></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Banner Area -->
</div>
<?php else: ?>
<header class="<?php echo e(request()->is('hotel/home')?'':'header-section'); ?> mb-3">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="at-home-menu-wrap">
                    <div>
                        <a href="<?php echo e(route('home')); ?>" class="d-block atn-logo">
                            <?php if(get_frontend_settings('light_logo')): ?>
                                <img src="<?php echo e(asset('uploads/logo/' . get_frontend_settings('light_logo'))); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                            <?php else: ?>
                                <img src="<?php echo e(asset('uploads/logo/light_logo.svg')); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                            <?php endif; ?>
                        </a>
                    </div>
                    <div class="at-home-menu-button ca-home-menu-button">
                        <!-- offcanvas menu start -->
                        <div class="offcanvas-xl offcanvas-end at-home-offcanvas" tabindex="-1" id="offcanvasResponsive" aria-labelledby="offcanvasResponsiveLabel">
                            <div class="offcanvas-header">
                                <div>
                                    <a href="<?php echo e(route('home')); ?>" class="d-block atn-logo">
                                        <?php if(get_frontend_settings('light_logo')): ?>
                                            <img src="<?php echo e(asset('uploads/logo/' . get_frontend_settings('light_logo'))); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('uploads/logo/light_logo.svg')); ?>" alt="" class="radious-15px px-2 py-2 light-logo-preview h-77">
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" data-bs-target="#offcanvasResponsive" aria-label="Close"></button>
                            </div>
                            <div class="offcanvas-body">
                                <nav>
                                    <ul class="at-home-navbar-nav bt-home-navbar-nav">
                                        <?php
                                        $menu_items = json_decode(get_frontend_settings('menu')); 
                                    ?>
                                    <?php $__currentLoopData = $menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($key < 2): ?> 
                                            <?php if($item == 'Hotel'): ?> 
                                                <li><a class="at-home-nav-link <?php echo e(request()->routeIs('hotel.home') ? 'active' : ''); ?>" href="<?php echo e(route('hotel.home')); ?>"><?php echo e(get_phrase('Hotel')); ?></a></li>
                                            <?php elseif($item == 'Real-Estate'): ?> 
                                                <li><a class="at-home-nav-link <?php echo e(request()->routeIs('real-estate.home') ? 'active' : ''); ?>" href="<?php echo e(route('real-estate.home')); ?>"><?php echo e(get_phrase('Real Estate')); ?></a></li>
                                            <?php elseif($item == 'Car'): ?> 
                                                <li><a class="at-home-nav-link <?php echo e(request()->routeIs('car.home') ? 'active' : ''); ?>" href="<?php echo e(route('car.home')); ?>"><?php echo e(get_phrase('Car')); ?></a></li>
                                            <?php elseif($item == 'Restaurant'): ?> 
                                                <li><a class="at-home-nav-link <?php echo e(request()->routeIs('restaurant.home') ? 'active' : ''); ?>" href="<?php echo e(route('restaurant.home')); ?>"><?php echo e(get_phrase('Restaurant')); ?></a></li>
                                            <?php elseif($item == 'Beauty'): ?> 
                                                <li><a class="at-home-nav-link <?php echo e(request()->routeIs('beauty.home') ? 'active' : ''); ?>" href="<?php echo e(route('beauty.home')); ?>"><?php echo e(get_phrase('Beauty')); ?></a></li>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                    <?php if(count($menu_items) > 2): ?>
                                        <li class="have-sub-menu">
                                            <a href="javascript:void(0);" class="at-home-nav-link first-a">
                                                <span><?php echo e(get_phrase('More')); ?></span>
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M15.5917 7.84025C15.5142 7.76214 15.422 7.70015 15.3205 7.65784C15.2189 7.61553 15.11 7.59375 15 7.59375C14.89 7.59375 14.7811 7.61553 14.6795 7.65784C14.578 7.70015 14.4858 7.76214 14.4083 7.84025L10.5917 11.6569C10.5142 11.735 10.422 11.797 10.3205 11.8393C10.2189 11.8816 10.11 11.9034 10 11.9034C9.89 11.9034 9.78108 11.8816 9.67953 11.8393C9.57798 11.797 9.48581 11.735 9.40834 11.6569L5.59168 7.84025C5.51421 7.76214 5.42204 7.70015 5.32049 7.65784C5.21894 7.61553 5.11002 7.59375 5.00001 7.59375C4.89 7.59375 4.78108 7.61553 4.67953 7.65784C4.57798 7.70015 4.48581 7.76214 4.40834 7.84025C4.25313 7.99638 4.16602 8.20759 4.16602 8.42775C4.16602 8.6479 4.25313 8.85911 4.40834 9.01525L8.23334 12.8402C8.70209 13.3084 9.33751 13.5714 10 13.5714C10.6625 13.5714 11.2979 13.3084 11.7667 12.8402L15.5917 9.01525C15.7469 8.85911 15.834 8.6479 15.834 8.42775C15.834 8.20759 15.7469 7.99638 15.5917 7.84025Z" fill="#555558"/>
                                                </svg>                                                    
                                            </a>
                                            <ul class="first-sub-menu">
                                                <?php $__currentLoopData = $menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($key >= 2): ?> 
                                                        <?php if($item == 'Hotel'): ?> 
                                                            <li><a class="<?php echo e(request()->routeIs('hotel.home') ? 'active' : ''); ?>" href="<?php echo e(route('hotel.home')); ?>"><?php echo e(get_phrase('Hotel')); ?></a></li>
                                                        <?php elseif($item == 'Real-Estate'): ?> 
                                                            <li><a class="at-home-nav-link <?php echo e(request()->routeIs('real-estate.home') ? 'active' : ''); ?>" href="<?php echo e(route('real-estate.home')); ?>"><?php echo e(get_phrase('Real Estate')); ?></a></li>
                                                        <?php elseif($item == 'Car'): ?> 
                                                            <li><a class="at-home-nav-link <?php echo e(request()->routeIs('car.home') ? 'active' : ''); ?>" href="<?php echo e(route('car.home')); ?>"><?php echo e(get_phrase('Car')); ?></a></li>
                                                        <?php elseif($item == 'Restaurant'): ?> 
                                                            <li><a class="at-home-nav-link <?php echo e(request()->routeIs('restaurant.home') ? 'active' : ''); ?>" href="<?php echo e(route('restaurant.home')); ?>"><?php echo e(get_phrase('Restaurant')); ?></a></li>
                                                        <?php elseif($item == 'Beauty'): ?> 
                                                            <li><a class="at-home-nav-link <?php echo e(request()->routeIs('beauty.home') ? 'active' : ''); ?>" href="<?php echo e(route('beauty.home')); ?>"><?php echo e(get_phrase('Beauty')); ?></a></li>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </li>
                                    <?php endif; ?>
                                
                                    <li><a href="<?php echo e(route('listing.view', ['type' => 'hotel', 'view' => 'grid'])); ?>" 
                                           class="at-home-nav-link <?php echo e(request()->routeIs('listing.view') ? 'active' : ''); ?>">
                                           <?php echo e(get_phrase('Listing')); ?>

                                    </a></li>
                                    </ul>                                    
                                </nav>
                            </div>
                        </div>
                        <!-- offcanvas menu end -->
                        <div class="at-home-search-login-button">
                            <div class="at-home-nav-search ca-home-nav-search d-none d-md-block">

                                <form class="at-home-search-form" action="<?php echo e(route('ListingsFilter')); ?>" method="get">
                                    <input type="hidden" name="type" value="hotel">
                                    <input type="hidden" name="view" value="grid">
                                   <div class="at-home-nav-label">
                                        <input type="search" class="at-home-search-input car-home-search-input" placeholder="Search …"  title="Search for:" name="title">
                                        <button type="submit" class="at-home-search-btn ca-home-search-btn">
                                            <img src="<?php echo e(asset('assets/frontend/images/icons/search-white-16.svg')); ?>" alt="">
                                        </button>
                                    </div>
                                </form>

                            </div>
                            <!-- For Login -->
                            <?php if(user('role') == 1): ?>
                            <div class="dropdown at-user-dropdown">
                                <button class="btn user-dropdown-toggle dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <img src="<?php echo e(user('image') ? asset('storage/users/' . user('image')) : asset('image/user.jpg')); ?>" alt="">
                                </button>
                                <div class="dropdown-menu user-dropdown-menu">
                                    <ul class="user-dropdown-group">
                                        <li><a class="user-dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>">
                                            <span class="icon fi-rr-apps mt-2px"></span>
                                            <span class="mt-2px"><?php echo e(get_phrase('Dashboard')); ?></span>
                                        </a></li>
                                    </ul>
                                    <div class="px-10px py-12px">
                                        <a href="<?php echo e(route('logout')); ?>" class="user-dropdown-item">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M10.1599 14.8467L10.0733 14.8467C7.11326 14.8467 5.6866 13.68 5.43993 11.0667C5.41326 10.7933 5.61326 10.5467 5.89326 10.52C6.15993 10.4933 6.41326 10.7 6.43993 10.9733C6.63326 13.0667 7.61993 13.8467 10.0799 13.8467L10.1666 13.8467C12.8799 13.8467 13.8399 12.8867 13.8399 10.1733L13.8399 5.82665C13.8399 3.11332 12.8799 2.15332 10.1666 2.15332L10.0799 2.15332C7.6066 2.15332 6.61993 2.94665 6.43993 5.07999C6.4066 5.35332 6.17326 5.55999 5.89326 5.53332C5.61326 5.51332 5.41326 5.26665 5.43326 4.99332C5.65993 2.33999 7.09326 1.15332 10.0733 1.15332L10.1599 1.15332C13.4333 1.15332 14.8333 2.55332 14.8333 5.82665L14.8333 10.1733C14.8333 13.4467 13.4333 14.8467 10.1599 14.8467Z" fill="#99A1B7"/>
                                                <path d="M10 8.5L2.41333 8.5C2.14 8.5 1.91333 8.27333 1.91333 8C1.91333 7.72667 2.14 7.5 2.41333 7.5L10 7.5C10.2733 7.5 10.5 7.72667 10.5 8C10.5 8.27333 10.2733 8.5 10 8.5Z" fill="#99A1B7"/>
                                                <path d="M3.89988 10.7333C3.77321 10.7333 3.64655 10.6866 3.54655 10.5866L1.31321 8.35331C1.11988 8.15998 1.11988 7.83998 1.31321 7.64664L3.54655 5.41331C3.73988 5.21998 4.05988 5.21998 4.25321 5.41331C4.44655 5.60664 4.44655 5.92664 4.25321 6.11998L2.37321 7.99998L4.25321 9.87998C4.44655 10.0733 4.44655 10.3933 4.25321 10.5866C4.15988 10.6866 4.02655 10.7333 3.89988 10.7333Z" fill="#99A1B7"/>
                                            </svg>
                                            <span class="mt-2px"><?php echo e(get_phrase('Log Out')); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php elseif(user('role') == 2): ?>
                            <div class="dropdown at-user-dropdown">
                                <button class="btn user-dropdown-toggle dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <img src="<?php echo e(user('image') ? asset('storage/users/' . user('image')) : asset('image/user.jpg')); ?>" alt="">
                                </button>
                                <div class="dropdown-menu user-dropdown-menu">
                                    <ul class="user-dropdown-group">
                                       
                                        <li><a class="user-dropdown-item" href="<?php echo e(route('user.account')); ?>">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99992 15.1666H5.99992C2.37992 15.1666 0.833252 13.6199 0.833252 9.99992V5.99992C0.833252 2.37992 2.37992 0.833252 5.99992 0.833252H7.33325C7.60659 0.833252 7.83325 1.05992 7.83325 1.33325C7.83325 1.60659 7.60659 1.83325 7.33325 1.83325H5.99992C2.92658 1.83325 1.83325 2.92658 1.83325 5.99992V9.99992C1.83325 13.0733 2.92658 14.1666 5.99992 14.1666H9.99992C13.0733 14.1666 14.1666 13.0733 14.1666 9.99992V8.66658C14.1666 8.39325 14.3933 8.16658 14.6666 8.16658C14.9399 8.16658 15.1666 8.39325 15.1666 8.66658V9.99992C15.1666 13.6199 13.6199 15.1666 9.99992 15.1666Z" fill="#99A1B7"/>
                                                <path d="M5.66664 11.7934C5.25997 11.7934 4.88664 11.6467 4.61331 11.38C4.28664 11.0534 4.14664 10.58 4.21997 10.08L4.50664 8.07337C4.55997 7.68671 4.8133 7.18671 5.08664 6.91337L10.34 1.66004C11.6666 0.333372 13.0133 0.333372 14.34 1.66004C15.0666 2.38671 15.3933 3.12671 15.3266 3.86671C15.2666 4.46671 14.9466 5.05337 14.34 5.65337L9.08664 10.9067C8.8133 11.18 8.3133 11.4334 7.92664 11.4867L5.91997 11.7734C5.8333 11.7934 5.74664 11.7934 5.66664 11.7934ZM11.0466 2.36671L5.7933 7.62004C5.66664 7.74671 5.51997 8.04004 5.4933 8.21337L5.20664 10.22C5.17997 10.4134 5.21997 10.5734 5.31997 10.6734C5.41997 10.7734 5.57997 10.8134 5.7733 10.7867L7.77997 10.5C7.9533 10.4734 8.2533 10.3267 8.3733 10.2L13.6266 4.94671C14.06 4.51337 14.2866 4.12671 14.32 3.76671C14.36 3.33337 14.1333 2.87337 13.6266 2.36004C12.56 1.29337 11.8266 1.59337 11.0466 2.36671Z" fill="#99A1B7"/>
                                                <path d="M13.2333 6.55343C13.1866 6.55343 13.14 6.54677 13.1 6.53343C11.3466 6.0401 9.95329 4.64677 9.45996 2.89343C9.38662 2.62677 9.53996 2.35343 9.80662 2.27343C10.0733 2.2001 10.3466 2.35343 10.42 2.6201C10.82 4.0401 11.9466 5.16677 13.3666 5.56677C13.6333 5.6401 13.7866 5.9201 13.7133 6.18677C13.6533 6.41343 13.4533 6.55343 13.2333 6.55343Z" fill="#99A1B7"/>
                                            </svg>
                                            <span class="mt-2px"><?php echo e(get_phrase('Profile')); ?></span>
                                        </a></li>
                                       
                                    </ul>
                                    <div class="px-10px py-12px">
                                        <a href="<?php echo e(route('logout')); ?>" class="user-dropdown-item">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M10.1599 14.8467L10.0733 14.8467C7.11326 14.8467 5.6866 13.68 5.43993 11.0667C5.41326 10.7933 5.61326 10.5467 5.89326 10.52C6.15993 10.4933 6.41326 10.7 6.43993 10.9733C6.63326 13.0667 7.61993 13.8467 10.0799 13.8467L10.1666 13.8467C12.8799 13.8467 13.8399 12.8867 13.8399 10.1733L13.8399 5.82665C13.8399 3.11332 12.8799 2.15332 10.1666 2.15332L10.0799 2.15332C7.6066 2.15332 6.61993 2.94665 6.43993 5.07999C6.4066 5.35332 6.17326 5.55999 5.89326 5.53332C5.61326 5.51332 5.41326 5.26665 5.43326 4.99332C5.65993 2.33999 7.09326 1.15332 10.0733 1.15332L10.1599 1.15332C13.4333 1.15332 14.8333 2.55332 14.8333 5.82665L14.8333 10.1733C14.8333 13.4467 13.4333 14.8467 10.1599 14.8467Z" fill="#99A1B7"/>
                                                <path d="M10 8.5L2.41333 8.5C2.14 8.5 1.91333 8.27333 1.91333 8C1.91333 7.72667 2.14 7.5 2.41333 7.5L10 7.5C10.2733 7.5 10.5 7.72667 10.5 8C10.5 8.27333 10.2733 8.5 10 8.5Z" fill="#99A1B7"/>
                                                <path d="M3.89988 10.7333C3.77321 10.7333 3.64655 10.6866 3.54655 10.5866L1.31321 8.35331C1.11988 8.15998 1.11988 7.83998 1.31321 7.64664L3.54655 5.41331C3.73988 5.21998 4.05988 5.21998 4.25321 5.41331C4.44655 5.60664 4.44655 5.92664 4.25321 6.11998L2.37321 7.99998L4.25321 9.87998C4.44655 10.0733 4.44655 10.3933 4.25321 10.5866C4.15988 10.6866 4.02655 10.7333 3.89988 10.7333Z" fill="#99A1B7"/>
                                            </svg>
                                            <span class="mt-2px"><?php echo e(get_phrase('Log Out')); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="login at-home-nav-link"><?php echo e(get_phrase('Login')); ?></a>
                            <?php endif; ?>
                            <?php if(check_subscription(user('id'))): ?> 
                            <a href="<?php echo e(route('agent.my_listings')); ?>" class="btn ca-btn-dark at-home-listing-btn d-flex align-items-center gap-2">
                                <img src="<?php echo e(asset('assets/frontend/images/icons/plus-white-8.svg')); ?>" alt="">
                                <span><?php echo e(get_phrase('Add Listing')); ?></span>
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('customer.become_an_agent')); ?>" class="btn ca-btn-dark at-home-listing-btn d-flex align-items-center gap-2">
                                <img src="<?php echo e(asset('assets/frontend/images/icons/plus-white-8.svg')); ?>" alt="">
                                <span><?php echo e(get_phrase('Add Listing')); ?></span>
                            </a>
                            <?php endif; ?>
                            <button class="btn at-home-menu-btn ca-home-menu-btn d-xl-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasResponsive" aria-controls="offcanvasResponsive">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" x="0" y="0" viewBox="0 0 24 24" style="enable-background:new 0 0 20 20" xml:space="preserve" class=""><g><path d="M21 7H8a1 1 0 0 1 0-2h13a1 1 0 0 1 0 2zm1 5a1 1 0 0 0-1-1H3a1 1 0 0 0 0 2h18a1 1 0 0 0 1-1zm0 6a1 1 0 0 0-1-1h-9a1 1 0 0 0 0 2h9a1 1 0 0 0 1-1z" fill="#6c1cff" opacity="1" data-original="#000000" class=""></path></g></svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<?php endif; ?><?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/layouts/hotel/header.blade.php ENDPATH**/ ?>