
<?php if($type == 'car' || $type == 'beauty' || $type == 'hotel' || $type == 'real-estate' || $type == 'restaurant'): ?>
    <?php
        $coordinates = [];
    ?>
    <?php $__currentLoopData = $listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $images = json_decode($listing->image, true); // JSON থেকে array বানানো
            $image = isset($images[0]) ? asset('uploads/listing-images/' . $images[0]) : asset('image/placeholder.png');

            $latitude = $listing->Latitude;
            $longitude = $listing->Longitude;
            // $country  = $listing->country;
            $country = App\Models\Country::where('id', $listing->country)->first(); 
            $city = App\Models\City::where('id', $listing->city)->first(); 

            $name = $listing->title ?? ''; 

            if ($latitude && $longitude) {
                $coordinates[] = [
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                    'name' => $name,
                    'image' => $image,
                    'country' => $country->name,
                    'city' => $city->name
                ];
            }
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

        <div class="car-map-area eRow">
            <div id="map" class="h-500"></div>
        </div>
        
        <script src="<?php echo e(asset('assets/frontend/js/mapbox-gl.js')); ?>"></script>
        <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/mapbox-gl.css')); ?>">

    


    <script>
        "use strict";
        mapboxgl.accessToken = '<?php echo e(get_settings('map_access_token')); ?>';
        var zoom = '<?php echo e(get_settings('max_zoom_level')); ?>';
        var coordinates = <?php echo json_encode($coordinates, 15, 512) ?>;
        var bounds = new mapboxgl.LngLatBounds();
    
        // Initialize the map
        var map = new mapboxgl.Map({
            container: 'map',
            style: 'mapbox://styles/mapbox/streets-v11',
            zoom: 1
        });
    
        coordinates.forEach(function(coordinate) {
            var imageUrl = coordinate.image || '<?php echo e(asset("image/placeholder.png")); ?>';
    
            var popupContent = `
                <div>
                    <img src="${imageUrl}" alt="Listing Image" style="width: 100%; height: 100px; border-radius: 5px; margin-bottom: 5px; object-fit:cover;">
                    <div class="coorName">
                      <h3>${coordinate.name}</h3>
                        <div class="mLocation">
                            <p>${coordinate.country}</p>
                            <p>${coordinate.city}</p>     
                        </div>    
                    </div>
                </div>
            `;
    
            var popup = new mapboxgl.Popup({ offset: 25 }).setHTML(popupContent);
    
            new mapboxgl.Marker()
                .setLngLat([coordinate.longitude, coordinate.latitude])
                .setPopup(popup)
                .addTo(map);
    
            bounds.extend([coordinate.longitude, coordinate.latitude]);
        });
    
        // Fit the map to the bounds
        map.fitBounds(bounds);
    </script>
    

<script>
    "use strict";
    document.addEventListener("DOMContentLoaded", function() {
        var checkboxes = document.querySelectorAll(".switch-checkbox");
        var eRows = document.querySelectorAll(".eRow");
        eRows.forEach(function(eRow) {
            eRow.classList.remove("eShow");
        });
        checkboxes.forEach(function(checkbox) {
            checkbox.addEventListener("change", function() {
                if (checkbox.checked) {
                    eRows.forEach(function(eRow) {
                        eRow.classList.remove("eShow");
                    });
                } else {
                    eRows.forEach(function(eRow) {
                        eRow.classList.add("eShow");
                    });
                }
            });
        });
    });
</script>

<?php /**PATH C:\MAMP\htdocs\demoA\AtlasA\resources\views/frontend/map.blade.php ENDPATH**/ ?>