
<?php $__env->startPush('title', get_phrase('Hotel Grid')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('frontend_layout'); ?>

<!-- Start Content Area -->
<section class="mt-3">
    <div class="container">
        <div class="row row-28 mb-80">
            <!-- Sidebar -->
            <div class="col-xl-3 col-lg-4">
                <?php echo $__env->make('frontend.hotel.sidebar_hotel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <!-- Right Content Area -->
            <div class="col-xl-9 col-lg-8">
                <!-- Top Filter Area -->
                <div class="showing-result-header d-flex align-items-center justify-content-between flex-wrap">
                    <div class="listing-info info"> 
                      
                         <?php echo e(get_phrase('Showing').'  to '.count($listings).' '.get_phrase('of').' '.count($listings).' '.get_phrase('results')); ?> 
                       
                    </div>
                    <div class="filter-tab-switch d-flex align-items-center flex-wrap">
                        <a href="<?php echo e(route('listing.view',['type'=>'hotel','view'=>'grid'])); ?>" class="<?php echo e(request()->is('listing/hotel/grid')?'active':''); ?> grid-list">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.5 10.9V4.1C21.5 2.6 20.86 2 19.27 2H15.23C13.64 2 13 2.6 13 4.1V10.9C13 12.4 13.64 13 15.23 13H19.27C20.86 13 21.5 12.4 21.5 10.9Z" fill="#555558"/>
                                <path d="M11 13.1V19.9C11 21.4 10.36 22 8.77 22H4.73C3.14 22 2.5 21.4 2.5 19.9V13.1C2.5 11.6 3.14 11 4.73 11H8.77C10.36 11 11 11.6 11 13.1Z" fill="#555558"/>
                                <path d="M21.5 19.9V17.1C21.5 15.6 20.86 15 19.27 15H15.23C13.64 15 13 15.6 13 17.1V19.9C13 21.4 13.64 22 15.23 22H19.27C20.86 22 21.5 21.4 21.5 19.9Z" fill="#555558"/>
                                <path d="M11 6.9V4.1C11 2.6 10.36 2 8.77 2H4.73C3.14 2 2.5 2.6 2.5 4.1V6.9C2.5 8.4 3.14 9 4.73 9H8.77C10.36 9 11 8.4 11 6.9Z" fill="#555558"/>
                            </svg>                                            
                        </a>
                        <a href="<?php echo e(route('listing.view',['type'=>'hotel','view'=>'list'])); ?>" class="<?php echo e(request()->is('listing/hotel/list')?'active':''); ?> grid-list">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M22 5.21429C22 5.88619 21.4417 6.42857 20.75 6.42857H3.25C2.55833 6.42857 2 5.88619 2 5.21429C2 4.54238 2.55833 4 3.25 4H20.75C21.4417 4 22 4.54238 22 5.21429ZM7.41667 18.5714H3.25C2.55833 18.5714 2 19.1138 2 19.7857C2 20.4576 2.55833 21 3.25 21H7.41667C8.10833 21 8.66667 20.4576 8.66667 19.7857C8.66667 19.1138 8.10833 18.5714 7.41667 18.5714ZM14.0833 11.2857H3.25C2.55833 11.2857 2 11.8281 2 12.5C2 13.1719 2.55833 13.7143 3.25 13.7143H14.0833C14.775 13.7143 15.3333 13.1719 15.3333 12.5C15.3333 11.8281 14.775 11.2857 14.0833 11.2857Z" fill="#555558"/>
                            </svg>                                            
                        </a>
                        <div class="switch-wrap">
                            <div class="switch-button">
                                <input type="checkbox" class="switch-checkbox" checked>
                                <div class="knobs">
                                  <span></span>
                                </div>
                                <div class="layer"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Google Map -->
                <?php if(get_frontend_settings('map_position') == 'top'): ?>
                    <!-- Map Area -->
                    <?php echo $__env->make('frontend.map', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <div class="row">
                    <div class="<?php echo e(get_frontend_settings('map_position') == 'right'?'col-xl-8':'col-xl-12'); ?> col-lg-12 order-2 order-xl-1" id="right-map">
                        <!-- Card Area -->
                        <?php if(count($listings) > 0): ?>
                        <div class="row row-28">
                            <?php $__currentLoopData = $listings->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Single Card -->
                            <div class="col-sm-6 <?php echo e(get_frontend_settings('map_position') == 'right'?'col-sm-6':'col-xl-4'); ?> map-card">
                                <div class="single-grid-card">
                                    <!-- Banner Slider -->
                                    <div class="grid-slider-area">
                                        <div class="swiper grid-banner-slider">
                                            <div class="swiper-wrapper">
                                                <?php $__currentLoopData = json_decode($listing->image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                                                    <div class="swiper-slide">
                                                        <div class="grid-slide-img">
                                                            <img src="<?php echo e(get_image('storage/listing-images/'.$image)); ?>" alt="">
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <div class="swiper-button-next"></div>
                                            <div class="swiper-button-prev"></div>
                                            <div class="swiper-pagination"></div>
                                            <p class="grid-slider-counter d-flex align-items-center justify-content-center"><span class="current-slide"><?php echo e(get_phrase('00')); ?></span>/<span class="total-slides"><?php echo e(get_phrase('00')); ?></span></p>
                                        </div>
                                        <p class="card-light-text theme-light capitalize"><?php echo e($listing->is_popular); ?></p>
                                        <?php
                                            $is_in_wishlist = check_wishlist_status($listing->id, $listing->type);
                                        ?>
                                        <a href="javascript:void(0);" data-bs-toggle="tooltip" 
                                        data-bs-title="<?php echo e($is_in_wishlist ? get_phrase('Remove from Wishlist') : get_phrase('Add to Wishlist')); ?>" onclick="updateWishlist(this, '<?php echo e($listing->id); ?>')"  class="grid-list-bookmark white-bookmark <?php echo e($is_in_wishlist ? 'active' : ''); ?>">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M13.4361 3C12.7326 3.01162 12.0445 3.22023 11.4411 3.60475C10.8378 3.98927 10.3407 4.53609 10 5.18999C9.65929 4.53609 9.16217 3.98927 8.55886 3.60475C7.95554 3.22023 7.26738 3.01162 6.56389 3C5.44243 3.05176 4.38583 3.57288 3.62494 4.44953C2.86404 5.32617 2.4607 6.48707 2.50302 7.67861C2.50302 10.6961 5.49307 13.9917 8.00081 16.2262C8.56072 16.726 9.26864 17 10 17C10.7314 17 11.4393 16.726 11.9992 16.2262C14.5069 13.9917 17.497 10.6961 17.497 7.67861C17.5393 6.48707 17.136 5.32617 16.3751 4.44953C15.6142 3.57288 14.5576 3.05176 13.4361 3Z" fill="#6C1CFF"/>
                                            </svg>                                                 
                                        </a>
                                    </div>
                                    <div class="hotel-grid-details position-relative">
                                        <a href="<?php echo e(route('listing.details',['type'=>$type, 'id'=>$listing->id, 'slug'=>slugify($listing->title)])); ?>" class="title stretched-link"> <?php echo e($listing->title); ?> </a>

                                        <div class="hotelgrid-location-rating d-flex align-items-center justify-content-between flex-wrap">
                                            <div class="location d-flex">
                                                <img src="<?php echo e(asset('assets/frontend/images/icons/location-gray-16.svg')); ?>" alt="">
                                                <?php
                                                    $city_name = App\Models\City::where('id',$listing->city)->first()->name;
                                                    $country_name = App\Models\Country::where('id',$listing->country)->first()->name;
                                                ?>
                                                <p class="name"> <?php echo e($city_name.', '.$country_name); ?> </p>
                                            </div>
                                            <?php
                                            $reviews_count = App\Models\Review::where('listing_id', $listing->id)
                                                ->where('user_id', '!=', $listing->user_id)->where('type', 'hotel')->where('reply_id', NULL)
                                                ->count();
                                            $total_ratings = App\Models\Review::where('listing_id', $listing->id)
                                                ->where('user_id', '!=', $listing->user_id)->where('type', 'hotel')->where('reply_id', NULL)
                                                ->sum('rating');  
                                            $average_rating = $reviews_count > 0 ? $total_ratings / $reviews_count : 0; 
                                        ?>
                                            <div class="ratings d-flex align-items-center">
                                                <p class="rating"><?php echo e(number_format($average_rating, 1)); ?></p> 
                                                <img src="<?php echo e(asset('assets/frontend/images/icons/star-yellow-20.svg')); ?>" alt="">
                                                <p class="reviews">(<?php echo e($reviews_count); ?>)</p> 
                                            </div>
                                        </div>
                                        <ul class="hotelgrid-list-items d-flex align-items-center flex-wrap">
                                            <?php
                                                if(isset($listing->feature) && is_array(json_decode($listing->feature))){
                                                    $features = json_decode($listing->feature);
                                                    foreach ($features as $key => $item) {
                                                       $feature = App\Models\Amenities::where('id', $item)->first();
                                                       if ($key < 2) {
                                                        echo "<li>".$feature->name."</li>";
                                                       } 
                                                    }
                                                    $more_amenities = count(json_decode($listing->feature));
                                                    if($more_amenities > 4){
                                                        echo "<li class='more'>+".($more_amenities-4).' '.get_phrase('More')."</li>";
                                                    }
                                                }
                                            ?>
                                        </ul>
                                        <div class="hotelgrid-see-price d-flex align-items-center justify-content-between">
                                            <a href="<?php echo e(route('listing.details',['type'=>$type, 'id'=>$listing->id, 'slug'=>slugify($listing->title)])); ?>" class="see-details-btn1"><?php echo e(get_phrase('See Details')); ?></a>
                                            <div class="prices d-flex">
                                                <p class="price"><?php echo e(currency($listing->price)); ?></p>
                                                <p class="time">/<?php echo e(get_phrase('night')); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="listing-pegination paginationColor">
                                <?php echo e($listings->links()); ?>

                            </div>
                        </div>
                        <?php else: ?> 
                            <?php echo $__env->make('frontend.no_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                    <?php if(get_frontend_settings('map_position') == 'right'): ?>    
                    <!-- Map Area -->
                    <div class="col-xl-4 col-lg-12 order-1 order-xl-2">
                        <?php echo $__env->make('frontend.map', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Content Area -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

<?php if(Auth::check()): ?>
 <script>
    "use strict";
function updateWishlist(button, listingId) {
    const bookmarkButton = $(button);
    const isActive = bookmarkButton.hasClass('active');
    bookmarkButton.toggleClass('active'); 
    const newTooltipText = isActive ? 'Add to Wishlist' : 'Remove from Wishlist';
    bookmarkButton.attr('data-bs-title', newTooltipText);

    const tooltipInstance = bootstrap.Tooltip.getInstance(button);
    if (tooltipInstance) tooltipInstance.dispose(); 
    new bootstrap.Tooltip(button); 

    $.ajax({
        url: '<?php echo e(route("wishlist.update")); ?>', 
        method: 'POST', 
        data: {
            listing_id: listingId,
            type: 'hotel', 
            user_id: <?php echo e(auth()->check() ? auth()->id() : 'null'); ?>, 
            _token: '<?php echo e(csrf_token()); ?>',
        },
        success: function (response) {
            if (response.status === 'success') {
                success(response.message);
            } 
            else if (response.status === 'error') {
                bookmarkButton.toggleClass('active');
                const revertTooltipText = isActive ? 'Remove from Wishlist' : 'Add to Wishlist';
                bookmarkButton.attr('data-bs-title', revertTooltipText);
                const revertTooltipInstance = bootstrap.Tooltip.getInstance(button);
                if (revertTooltipInstance) revertTooltipInstance.dispose();
                new bootstrap.Tooltip(button);
            }
        },
        error: function (xhr) {
            bookmarkButton.toggleClass('active');
            const revertTooltipText = isActive ? 'Remove from Wishlist' : 'Add to Wishlist';
            bookmarkButton.attr('data-bs-title', revertTooltipText);
            const revertTooltipInstance = bootstrap.Tooltip.getInstance(button);
            if (revertTooltipInstance) revertTooltipInstance.dispose();
            new bootstrap.Tooltip(button);
        },
    });
}
    </script>
    <?php else: ?>
        <script>
            "use strict";
            function updateWishlist(listing_id) {
                warning("Please login first!");
            }
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/frontend/hotel/grid_listing.blade.php ENDPATH**/ ?>